/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;

class MemoryFreeList {
    ArrayList elementData = null;
    int size = 0;
    int currBlockSize = 10;
    Object[] currBlock = null;
    int currBlockIndex = 0;
    int spaceUsed = 0;
    int numBlocks = 0;
    int capacity = 0;
    int minBlockSize = 0;
    boolean justShrunk = false;
    int initcap = 10;
    int minSize = 0;
    Class c = null;

    MemoryFreeList(String string) {
        this(string, 10);
    }

    MemoryFreeList(String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        try {
            this.c = Class.forName(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.initcap = n2;
        this.minBlockSize = this.currBlockSize = n2;
        this.elementData = new ArrayList();
        this.currBlock = new Object[this.currBlockSize];
        this.elementData.add(this.currBlock);
        ++this.numBlocks;
        this.capacity += this.currBlockSize;
    }

    synchronized int size() {
        return this.size;
    }

    synchronized boolean add(Object object) {
        if (this.justShrunk) {
            if (this.currBlockSize / 2 < this.spaceUsed) {
                this.size -= this.spaceUsed - this.currBlockSize / 2;
                this.spaceUsed = this.currBlockSize / 2;
                Arrays.fill(this.currBlock, this.spaceUsed, this.currBlockSize - 1, null);
            }
            this.justShrunk = false;
            return false;
        }
        this.ensureCapacity(this.size + 1);
        if (this.currBlockIndex == -1 || this.spaceUsed >= this.currBlockSize) {
            ++this.currBlockIndex;
            this.currBlock = (Object[])this.elementData.get(this.currBlockIndex);
            this.currBlockSize = this.currBlock.length;
            this.spaceUsed = 0;
        }
        int n2 = this.spaceUsed++;
        this.currBlock[n2] = object;
        ++this.size;
        return true;
    }

    protected synchronized Object removeLastElement() {
        int n2 = --this.spaceUsed;
        Object object = this.currBlock[n2];
        this.currBlock[n2] = null;
        --this.size;
        if (this.spaceUsed == 0) {
            --this.currBlockIndex;
            if (this.currBlockIndex < 0) {
                this.currBlock = null;
                this.currBlockSize = 0;
            } else {
                this.currBlock = (Object[])this.elementData.get(this.currBlockIndex);
                this.currBlockSize = this.currBlock.length;
            }
            this.spaceUsed = this.currBlockSize;
        }
        return object;
    }

    synchronized void shrink() {
        if (this.minSize > this.minBlockSize && this.numBlocks > 1) {
            this.justShrunk = true;
            Object[] objectArray = (Object[])this.elementData.remove(this.numBlocks - 1);
            --this.numBlocks;
            this.capacity -= objectArray.length;
            if (this.numBlocks == this.currBlockIndex) {
                this.size -= this.spaceUsed;
                this.currBlockIndex = this.numBlocks - 1;
                this.currBlock = (Object[])this.elementData.get(this.currBlockIndex);
                this.spaceUsed = this.currBlockSize = this.currBlock.length;
            }
        } else {
            this.justShrunk = false;
        }
        this.minSize = this.size;
    }

    synchronized void ensureCapacity(int n2) {
        if (n2 > this.capacity) {
            int n3 = ((Object[])this.elementData.get(this.numBlocks - 1)).length;
            int n4 = 0;
            if (this.numBlocks > 1) {
                n4 = ((Object[])this.elementData.get(this.numBlocks - 2)).length;
            }
            this.currBlockSize = n3 + n4;
            this.currBlock = new Object[this.currBlockSize];
            this.elementData.add(this.currBlock);
            ++this.numBlocks;
            ++this.currBlockIndex;
            this.capacity += this.currBlockSize;
            this.spaceUsed = 0;
        }
    }

    synchronized void rangeCheck(int n2) {
        if (n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
    }

    public synchronized void clear() {
        this.elementData.clear();
        this.minBlockSize = this.currBlockSize = this.initcap;
        this.currBlock = new Object[this.currBlockSize];
        this.elementData.add(this.currBlock);
        this.numBlocks = 1;
        this.capacity = this.currBlockSize;
        this.spaceUsed = 0;
        this.size = 0;
        this.currBlockIndex = 0;
        this.justShrunk = false;
    }

    synchronized Object getObject() {
        if (this.size > 0) {
            return this.removeLastElement();
        }
        try {
            return this.c.newInstance();
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }
}

